# Intuition
<!-- Describe your first thoughts on how to solve this problem. -->
Keep a record of distance of target node from itself to root node, then traverse distances.

# Approach
<!-- Describe your approach to solving the problem. -->

Create a hashmap to store the distances of nodes in the path of target node to root node.

Then traverse from root node to check if asked distance(k) is equal to distance between target and that node. If not, then check node.left as well as node.right , after calling the same traverse function with incrementing distance by 1 . ( as by intuition we will be going away from target.) 
( But if we move closer to target node then don't worry , I have included the if statement to check is traversed node is in hashmap, if yes then update distance to the value of distance of that node in hashmap.)

# Complexity
- Time complexity: $$O(n)$$
<!-- Add your time complexity here, e.g. $$O(n)$$ -->

- Space complexity: $$O(n)$$
<!-- Add your space complexity here, e.g. $$O(n)$$ -->

# Code
```
/**
 * Definition for a binary tree node.
 * public class TreeNode {
 *     int val;
 *     TreeNode left;
 *     TreeNode right;
 *     TreeNode(int x) { val = x; }
 * }
 */
class Solution {
    public List<Integer> distanceK(TreeNode root, TreeNode target, int k) {
        List<Integer> li = new ArrayList<>();
        HashMap< TreeNode, Integer> dist = new HashMap<>();

        getDists( root, target, dist);
        traverse( root, k, 0, dist, li);

        return li;
        
    }

    static void getDists( TreeNode root, TreeNode target, HashMap< TreeNode, Integer> dist){

        if( root == null){
            return;
        }
        if( root == target){
            dist.put(root, 0);
            return;
        }

        getDists(root.left, target, dist);
        if( dist.containsKey(root.left)){
            dist.put(root, dist.get(root.left) + 1);
            return;
        }

        getDists(root.right, target, dist);
        if( dist.containsKey(root.right)){
            dist.put(root, dist.get(root.right) + 1);
            return;
        }

    }

    static void traverse( TreeNode root, int k, int distance, HashMap< TreeNode, Integer> dist, List<Integer> li){
        if( root == null){
            return;
        }
        if( dist.containsKey(root)){
            distance = dist.get(root);
        }
        if( distance == k){
            li.add(root.val);
        }

        traverse(root.left, k, distance + 1, dist, li);
        traverse(root.right, k, distance + 1, dist, li);
    }
}
```